

$(document).ready(function () {

    var A4formLists = [];
    $("img").each(function (index) {
        A4formLists.push($(this));
    });

    $("body").empty();
    for (var i in A4formLists) {
        var A4form = A4formLists[i];
        var url = A4form.attr("src");
        drawImgs(url);
    }


    setTimeout(function () {
        window.print();
    }, 800);


});


function drawImgs(url) {
    var originWidth = 2619;
    var originHeight = 4275;
	
	

    var width = originWidth / 2;
    var height = originHeight / 2;

    var canvas1 = document.createElement('canvas');
    var canvas2 = document.createElement('canvas');
    var canvas3 = document.createElement('canvas');
    var canvas4 = document.createElement('canvas');

    canvas1.width = width;
    canvas1.height = height;

    canvas2.width = width;
    canvas2.height = height;

    canvas3.width = width;
    canvas3.height = height;

    canvas4.width = width;
    canvas4.height = height;

    var ctx1 = canvas1.getContext('2d');
    var ctx2 = canvas2.getContext('2d');
    var ctx3 = canvas3.getContext('2d');
    var ctx4 = canvas4.getContext('2d');

    var img = new Image();
    img.onload = function () {
        ctx1.drawImage(this, 0, 0, width, height, 0, 0, width, height);
        if (getRGB(ctx1, originWidth, originHeight)) {
            $("body").append(canvas1);
        }
//            ctx1.getImageData(0, 0, this.width, this.height);


        ctx2.drawImage(this, width, 0, width, height, 0, 0, width, height);
        if (getRGB(ctx2, originWidth, originHeight)) {
            $("body").append(canvas2);
        }
//            ctx2.getImageData(0, 0, this.width, this.height);

        ctx3.drawImage(this, 0, height, width, height, 0, 0, width, height);
        if (getRGB(ctx3, originWidth, originHeight)) {
            $("body").append(canvas3);
        }
//            ctx3.getImageData(0, 0, this.width, this.height);

        ctx4.drawImage(this, width, height, width, height, 0, 0, width, height);
        if (getRGB(ctx4, originWidth, originHeight)) {
            $("body").append(canvas4);
        }
//            ctx4.getImageData(0, 0, this.width, this.height);
    };
    img.src = url;
}


function getRGB(ctx, width, height) {
    // 获取像素数据
    var data = ctx.getImageData(0, 0, width, height).data;

    var r = 0;
    var g = 0;
    var b = 0;

    // 取所有像素的平均值
    for (var row = 0; row < height; row++) {
        for (var col = 0; col < width; col++) {
            r += data[((width * row) + col) * 4];
            g += data[((width * row) + col) * 4 + 1];
            b += data[((width * row) + col) * 4 + 2];
        }
    }

    // 求取平均值
    r /= (width * height);
    g /= (width * height);
    b /= (width * height);

    // 将最终的值取整
    r = Math.round(r);
    g = Math.round(g);
    b = Math.round(b);

//    alert("rgb(" + r + "," + g + "," + b + ")");
    var avg = (r + g + b) / 3;
    var result = true;
    if ( (avg == 64 || avg == 63) || avg>=88 ) {
        result = false;
    }
	console.log(r+","+g+","+b);
    return result;
}